/*****************************************************************************/
/* File         regex.h                                                      */
/*                                                                           */
/* Purpose      Regular Expression Pattern Matching                          */
/*****************************************************************************/
#ifndef _REGEX_H
#define _REGEX_H

#include "dynarray.h"

#if defined(__cplusplus)
extern "C"
{
#endif

enum regmach_opcode_enum
{
  ro_not_used,
  ro_string_match,
  ro_start_of_line,
  ro_end_of_line,
  ro_goto,
  ro_push_fail_vec,
  ro_push_fail_count_vec,
  ro_match_any,
  ro_start_register,
  ro_end_register,
  ro_select,
  ro_not_select,
  ro_match_register,
  ro_end
};
typedef enum regmach_opcode_enum opcode_t;
typedef int progptr_t;
typedef int locn_t;
#define GOTO_SIZE (3)                                      /*Goto opcode size*/
#define GOTO_COUNT_SIZE (7)                                /*Goto opcode size*/
#define RE_MAX_REGISTERS (10)
struct re_prog_struct
{
  sdynarray_t code;                                        /*Program code    */
  char *string;                                            /*String to match */
  bool_t   active[RE_MAX_REGISTERS];                       /*TRUE if register*/
                                                           /* is set by      */
                                                           /* match          */
  unsigned start[RE_MAX_REGISTERS];                        /*offset in string*/
                                                           /* of start of    */
                                                           /* register text  */
  unsigned end[RE_MAX_REGISTERS];                          /* offset in strng*/
                                                           /* of end of      */
                                                           /* register text  */
  bool_t start_of_line_only;                               /*pattern got a ^ */
  bool_t initialised_table;                                /*Is the fast     */
                                                           /* search table   */
                                                           /* valid          */
  int    imatch_length;                                    /*Len of initial  */
                                                           /* match          */
  unsigned char  *imatch_string;                           /*Initial literal */
                                                           /* string used    */
                                                           /* in fast match. */
                                                           /* imatch_length  */
                                                           /* chars long.    */
  void_ptr_t table;                               /* Fast match table        */
};
#define PROG_TO_CODE(p) (&((p)->code))                     /*From program to */
                                                           /* byte opcodes   */
typedef struct re_prog_struct re_prog_t;

/***************************************************************************/
/* Type definition of the stack.  This holds the three status paramters    */
/* so that nesting of ( ) etc. is allowed                                  */
/***************************************************************************/
struct parse_stack_struct
{
  progptr_t patch_goto;                                    /*Locn to patch   */
  progptr_t lastexprptr;                                   /*Last expression */
  progptr_t lastbracket;                                   /*Last \( \)      */
                                                           /* expression     */
  unsigned  register_count;                                /*How many        */
                                                           /* registers used */
};
typedef struct parse_stack_struct parse_stack_t;

/*****************************************************************************/
/* Type definition of the run time stack.. This is used to push and trap     */
/* failures to match.  This allows back tracking and other useful techniques */
/*****************************************************************************/
struct run_stack_struct
{
  progptr_t progptr;                                       /* PC to jump to  */
  int       string;                                        /*Offset in string*/
                                                           /* to match       */
  progptr_t destination;
  unsigned  count;
  progptr_t count_location;
};
typedef struct run_stack_struct run_stack_t;

#if defined(SHORT_EXTERN_NAMES)
#define re_search resrch
#define re_search_unanchored resrchun
#define re_compile recomp
#define re_destroy redest
#define re_read_register rereadrg
#define re_error_string reerrstr
#endif

extern char *re_error_string;                              /*re_compile err  */
#if defined(_NO_PROTO)
extern  re_prog_t *re_compile();
extern  int re_search();
extern  int re_search_unanchored();
extern  void re_destroy();
extern  char *re_read_register();
#else
extern  re_prog_t *re_compile(char *patptr);
extern  int re_search(re_prog_t *program,char *string);
extern  int re_search_unanchored(re_prog_t *program,char *string,int *offset);
extern  void re_destroy(re_prog_t *program);
extern  char *re_read_register(re_prog_t *program,char *return_string,unsigned string_length,unsigned regnum);
#endif

#if defined(__cplusplus)
}
#endif

#endif
